<?php

require 'vendor/autoload.php';

use Longman\TelegramBot\Request;
use Longman\TelegramBot\Telegram;
use Longman\TelegramBot\Entities\Update;
use GuzzleHttp\Client;

$bot_api_key  = '7832222180:AAGKTWktOd4YhU6I8iOla9s_KliH0q41U3s';
$bot_username = 'PesaTaslimBot';
$safaricom_shortcode = '4123245';
$safaricom_passkey = '38468def9362d1a88d5061ebb5076e0b93a48236ddab1798666d899f84fac291';
$safaricom_callback_url = 'https://bot.kenyanebooks.co.ke/callback.php';

session_start();

try {
    $telegram = new Telegram($bot_api_key, $bot_username);
    $updates = Request::getUpdates();

    foreach ($updates->getResult() as $update) {
        $update = new Update($update);
        $message = $update->getMessage();
        $chat_id = $message->getChat()->getId();
        $text = trim($message->getText());

        if ($text === "/start") {
            $reply = "Welcome! Choose a service: \n\n1. Web Design\n2. Graphic Design\n3. Video Editing";
            Request::sendMessage(['chat_id' => $chat_id, 'text' => $reply]);
            $_SESSION['stage'] = 'choose_service';
        } elseif ($_SESSION['stage'] === 'choose_service' && in_array($text, ['1', '2', '3'])) {
            $reply = "Please enter your Safaricom number (format: 0701000000)";
            Request::sendMessage(['chat_id' => $chat_id, 'text' => $reply]);
            $_SESSION['stage'] = 'enter_phone';
        } elseif ($_SESSION['stage'] === 'enter_phone' && preg_match('/^07\d{8}$/', $text)) {
            $_SESSION['phone_number'] = $text;
            $_SESSION['amount'] = rand(1, 1);

            $reply = "For us to serve you, you need to pay a consultation fee of Ksh {$_SESSION['amount']}. STK push has been sent.";
            Request::sendMessage(['chat_id' => $chat_id, 'text' => $reply]);

            sendSTKPush($_SESSION['phone_number'], $_SESSION['amount'], $chat_id);
            $_SESSION['stage'] = 'waiting_payment';
        } elseif ($_SESSION['stage'] === 'waiting_payment') {
            $reply = "Payment is pending. Please complete the M-Pesa payment.";
            Request::sendMessage(['chat_id' => $chat_id, 'text' => $reply]);
        }
    }
} catch (Exception $e) {
    echo $e->getMessage();
}

function sendSTKPush($phone, $amount, $chat_id)
{
    global $safaricom_shortcode, $safaricom_passkey, $safaricom_callback_url;
    $pdo = new PDO("mysql:host=localhost;dbname=qztdvwbd_bot", "qztdvwbd_user", "TopManager@90");

    // Insert into database
    $stmt = $pdo->prepare("INSERT INTO payments (chat_id, phone, amount, status) VALUES (?, ?, ?, 'Pending')");
    $stmt->execute([$chat_id, $phone, $amount]);

    $client = new Client();
    $timestamp = date("YmdHis");
    $password = base64_encode($safaricom_shortcode . $safaricom_passkey . $timestamp);

    $response = $client->post('https://api.safaricom.co.ke/mpesa/stkpush/v1/processrequest', [
        'headers' => [
            'Authorization' => 'Bearer ' . getAccessToken(),
            'Content-Type' => 'application/json'
        ],
        'json' => [
            'BusinessShortCode' => $safaricom_shortcode,
            'Password' => $password,
            'Timestamp' => $timestamp,
            'TransactionType' => 'CustomerPayBillOnline',
            'Amount' => $amount,
            'PartyA' => $phone,
            'PartyB' => $safaricom_shortcode,
            'PhoneNumber' => $phone,
            'CallBackURL' => $safaricom_callback_url,
            'AccountReference' => "Consultation",
            'TransactionDesc' => "Consultation Fee"
        ]
    ]);

    $data = json_decode($response->getBody(), true);

    if (!isset($data['ResponseCode']) || $data['ResponseCode'] !== '0') {
        Request::sendMessage(['chat_id' => $chat_id, 'text' => "STK push failed. Please try again later."]);
    }
}

function getAccessToken()
{
    $client = new Client();
    $consumer_key = 'W8QyeBu9GaaGOuZMyHaH9MyRudSCiblZxGv7ShDDGHPbLbnS';
    $consumer_secret = 'UDSkXdLhgoCGo1SLqAAzWmBMO41R1YrpXahxwXqclAYwDPXvpZfbBIvGQsDbdjuX';

    $response = $client->request('GET', 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials', [
        'auth' => [$consumer_key, $consumer_secret]
    ]);

    $data = json_decode($response->getBody(), true);
    return $data['access_token'];
}
